// PoVRay 3.7 Scene File " ... .pov"
// author:  ...
// date:    ...
//--------------------------------------------------------------------------
#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 0.1 diffuse 0.9 }} 
//--------------------------------------------------------------------------

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera {perspective angle 75               // front view
                            location  <0.0 , 1.0 ,-3.0>
                            right     x*image_width/image_height
                            look_at   <0.0 , 1.0 , 0.0>}

// sun ----------------------------------------------------------------------
light_source{< 3000,3000,-3000> color rgb 1}
// sky ----------------------------------------------------------------------
sky_sphere { pigment { gradient <0,1,0>
                       color_map { [0.00 rgb <0.6,0.7,1.0>]
                                   [0.35 rgb <0.1,0.0,0.8>]
                                   [0.65 rgb <0.1,0.0,0.8>]
                                   [1.00 rgb <0.6,0.7,1.0>] 
                                 } 
                       scale 2         
                     } // end of pigment
           } //end of skysphere
// ground -------------------------------------------------------------------
plane{ <0,1,0>, 0 
       texture{ pigment{ checker color rgb<1,1,1>*1.2 color rgb<0.25,0.15,0.1>*0}
              //normal { bumps 0.75 scale 0.025}
                finish { phong 0.1}
              } // end of texture
     } // end of plane
//---------------------------------------------------------------------------
//---------------------------- objects in scene ----------------------------
//---------------------------------------------------------------------------

#declare Shape= // ==>> Insert your shape here ==>>
sphere{0,1 translate y}

#macro Pigm()  // ==>> Insert your main pigment here ==>>
    agate
      color_map {
                [0 color rgb <0,0,1>]
                [1 color rgb <0,1,1>]
              }
#end

#declare Threshold=0.5; // changes the area in the texture where the inner material starts in the main pigment
 
#declare Pigmt=pigment {
      Pigm()
    } 

#declare OuterMat= // ==>> Insert your Outer Material here (at least one material should have transparency) ==>>
material{texture{pigment{rgbt 1}
                 finish{}
                 }  
        interior{//ior 1.3 
                media {
                      // (---general values---)
                      /*intervals 10           // number of intervals used for sampling [10]
                      samples 1,1            // minimum and maximum number of samples taken per interval [1,1]
                      confidence 0.9         // statistic parameter higher->better quality [0.9]
                      variance 1.0/128       // statistic parameter lower->better quality [1.0/128]
                      ratio 0.9              // distribution between lit and unlit areas [0.9]
                      */
                      scattering {1, rgb 1 }
                      method 3               // adaptive sampling
                      density { Pigm() }
                      }
                }         
        }

#declare InnerMat=  // ==>> Insert your Inner Material here (at least one material should have transparency) ==>>
material{texture{pigment{Pigmt filter .9 transmit .1}
                 finish{specular .6 phong 1 reflection{0,1}}
                 }  
        interior{ior 1.5
                }         
        }


// end of custom declares

/////////////////////////////////////////////////////////////////


 
#declare fn_Pigm=function {pigment{Pigm()}} 

#declare IsoShape=
isosurface {
  function{fn_Pigm(x/2, y/2, z/2).gray}  
  
  threshold Threshold
  contained_by { box {min_extent(Shape),max_extent(Shape) } }
  accuracy 0.003
  max_gradient 5 // <<== Check max Gradient in messages after a test render <<== ***

} // end of isosurface ------------------------------


union{
    object{Shape
          material{OuterMat}   
          hollow
          }  
    
    intersection{
                object{Shape} 
                object{IsoShape} 
                material{InnerMat}   
                hollow
                } 
    } 
/////////////////////////////////////////////////////////////